/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.userrole;

import com.ibm.hwmca.base.userprof.RoleTree;
import com.ibm.hwmca.base.userrole.UserRoleErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.ArrayList;
import java.util.List;

public class AddRoleBean
extends PanelBean
implements UserRoleErrorIds {
    private String[] m_sRolesRBGSelection;
    private boolean m_bManagedToggle;
    private boolean m_bTaskToggle;
    private ItemDescriptor[] m_idObjectRoles;
    private ColumnDescriptor[] m_cdObjectRolesStructure;
    private int[] m_iObjectRolesSelection;
    private ItemDescriptor[] m_idTaskRoles;
    private ColumnDescriptor[] m_cdTaskRolesStructure;
    private int[] m_iTaskRolesSelection;
    List _systemObjects = new ArrayList();
    List _systemTasks = new ArrayList();
    List _systemRoles = new ArrayList();
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "com.ibm.hwmca.base.userrole.UserRole");
    UserTaskManager _utm;
    private static final String TRACE_MASKF = "USRARBSF";
    private static final String TRACE_MASKT = "USRARBST";
    private static final String TRACE_MASKD = "USRARBSD";

    public AddRoleBean() {
    }

    public AddRoleBean(List myTasks, List myObjects) {
        this._systemTasks = myTasks;
        this._systemObjects = myObjects;
        Trace.trace(TRACE_MASKT, "-> AddRoleBean() systemTasks " + this._systemTasks.size());
        Trace.trace(TRACE_MASKT, "AddRoleBean() systemObjects " + this._systemObjects.size());
    }

    public void update(Object updatedObjects) {
        List tempList = (List)updatedObjects;
        RoleTree tempTree = (RoleTree)tempList.get(0);
        if (tempTree.getType() == 0) {
            this._systemObjects = (List)updatedObjects;
            Trace.trace(TRACE_MASKT, "AddRoleBean() systemObjects " + this._systemObjects.size());
        } else {
            this._systemTasks = (List)updatedObjects;
            Trace.trace(TRACE_MASKT, "-> AddRoleBean.update systemTasks " + this._systemTasks.size());
        }
        this.fillRoles();
    }

    public void setRolesRBGSelection(String[] selected) throws IllegalUserDataException {
        this.m_sRolesRBGSelection = selected;
    }

    public String[] getRolesRBGSelection() {
        return this.m_sRolesRBGSelection;
    }

    public void setObjectRolesSelection(int[] selected) {
        int i;
        int selectValue = 0;
        if (selected != null) {
            i = 0;
            while (i < selected.length) {
                selectValue = i++;
            }
        }
        this.m_iObjectRolesSelection = new int[selected.length];
        i = 0;
        while (i < selected.length) {
            this.m_iObjectRolesSelection[i] = selected[i];
            selectValue = selected[i];
            ++i;
        }
    }

    public int[] getObjectRolesSelection() {
        return this.m_iObjectRolesSelection;
    }

    public void setObjectRolesRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idObjectRoles[index] = items[0];
    }

    public ItemDescriptor[] getObjectRolesRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[]{new ItemDescriptor()};
        rowAt[0] = this.m_idObjectRoles[index];
        return rowAt;
    }

    public int getObjectRolesRowCount() {
        int retCount = 0;
        if (this.m_idObjectRoles != null) {
            retCount = this.m_idObjectRoles.length;
        }
        return retCount;
    }

    public int getObjectRolesRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getObjectRolesRowStructure() {
        return this.m_cdObjectRolesStructure;
    }

    public void setTaskRolesSelection(int[] selected) {
        int i;
        int selectValue = 0;
        if (selected != null) {
            i = 0;
            while (i < selected.length) {
                selectValue = i++;
            }
        }
        this.m_iTaskRolesSelection = new int[selected.length];
        i = 0;
        while (i < selected.length) {
            this.m_iTaskRolesSelection[i] = selected[i];
            selectValue = selected[i];
            ++i;
        }
    }

    public int[] getTaskRolesSelection() {
        return this.m_iTaskRolesSelection;
    }

    public void setTaskRolesRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idTaskRoles[index] = items[0];
    }

    public ItemDescriptor[] getTaskRolesRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[]{new ItemDescriptor()};
        rowAt[0] = this.m_idTaskRoles[index];
        return rowAt;
    }

    public int getTaskRolesRowCount() {
        int retCount = 0;
        if (this.m_idTaskRoles != null) {
            retCount = this.m_idTaskRoles.length;
        }
        return retCount;
    }

    public int getTaskRolesRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getTaskRolesRowStructure() {
        return this.m_cdTaskRolesStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        String[] m = new String[]{"ManagedRolesItem"};
        this.setRolesRBGSelection(m);
        this.m_sRolesRBGSelection = new String[0];
        this.m_idObjectRoles = new ItemDescriptor[0];
        this.m_cdObjectRolesStructure = new ColumnDescriptor[0];
        this.m_iObjectRolesSelection = new int[0];
        this.m_idTaskRoles = new ItemDescriptor[0];
        this.m_cdTaskRolesStructure = new ColumnDescriptor[0];
        this.m_iTaskRolesSelection = new int[0];
    }

    public void setUTM(UserTaskManager utm) {
        this._utm = utm;
        this.fillRoles();
    }

    public UserTaskManager getUTM() {
        return this._utm;
    }

    public void prepare() {
        this.setUTM(this.userTaskManager);
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        Object mySelection = null;
        String actionCommand = event.getActionCommand();
        String command = event.getElementName();
        Object userSelected = null;
        int[] itemSelected = null;
        Object myObject = null;
        PanelTaskletRequest request = new PanelTaskletRequest();
        UserTaskManager utm = (UserTaskManager)event.getSource();
        boolean itemDeleted = false;
        if (utm == null || this.userTaskManager == null) {
            return;
        }
        try {
            utm.storeAllElements();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] actionSelection = this.getRolesRBGSelection();
        String actionTaken = actionSelection[0];
        if (command.equals("roleMenu.add")) {
            if (actionTaken.equals("ManagedRolesItem")) {
                request.setData("action", "objectAdd");
            } else {
                request.setData("action", "taskAdd");
            }
            this.postTaskletRequest(request);
        } else if (actionCommand.equalsIgnoreCase("roleMenu.copy")) {
            if (actionTaken.equals("ManagedRolesItem")) {
                itemSelected = this.getObjectRolesSelection();
                if (itemSelected != null) {
                    request.setData("index", new Integer(itemSelected[0]));
                    request.setData("action", "objectCopy");
                } else {
                    this.issueAddError();
                }
            } else {
                itemSelected = this.getTaskRolesSelection();
                if (itemSelected != null) {
                    request.setData("index", new Integer(itemSelected[0]));
                    request.setData("action", "taskCopy");
                } else {
                    this.issueAddError();
                }
            }
            this.postTaskletRequest(request);
        } else if (actionCommand.equalsIgnoreCase("roleMenu.remove")) {
            if (actionTaken.equals("ManagedRolesItem")) {
                itemSelected = this.getObjectRolesSelection();
                if (itemSelected != null) {
                    if (this.isRemoveable(itemSelected[0], 0)) {
                        request.setData("index", new Integer(itemSelected[0]));
                        request.setData("action", "objectRemove");
                        this.postTaskletRequest(request);
                    }
                } else {
                    this.issueAddError();
                }
            } else {
                itemSelected = this.getTaskRolesSelection();
                if (itemSelected != null) {
                    if (this.isRemoveable(itemSelected[0], 1)) {
                        request.setData("index", new Integer(itemSelected[0]));
                        request.setData("action", "taskRemove");
                        this.postTaskletRequest(request);
                    }
                } else {
                    this.issueAddError();
                }
            }
        } else if (actionCommand.equalsIgnoreCase("roleMenu.modify")) {
            if (actionTaken.equals("ManagedRolesItem")) {
                itemSelected = this.getObjectRolesSelection();
                if (itemSelected != null) {
                    request.setData("index", new Integer(itemSelected[0]));
                    request.setData("action", "objectModify");
                    this.postTaskletRequest(request);
                } else {
                    this.issueAddError();
                }
            } else {
                itemSelected = this.getTaskRolesSelection();
                if (itemSelected != null) {
                    request.setData("index", new Integer(itemSelected[0]));
                    request.setData("action", "taskModify");
                    this.postTaskletRequest(request);
                } else {
                    this.issueAddError();
                }
            }
        } else if (actionCommand.equalsIgnoreCase("CANCEL")) {
            request.setCanceled();
            this.postTaskletRequest(request);
        } else {
            this.dispose();
        }
    }

    public void fillRoles() {
        String itemName;
        RoleTree itemTree;
        ItemDescriptor[] newRow;
        int i = 0;
        int taskSize = 0;
        int objectSize = 0;
        taskSize = this._systemTasks.size();
        Trace.trace(TRACE_MASKT, "-> AddRoleBean.fillRoles systemTasks " + this._systemTasks.size());
        this.m_idTaskRoles = new ItemDescriptor[taskSize];
        this.m_cdTaskRolesStructure = new ColumnDescriptor[0];
        this.m_iTaskRolesSelection = new int[1];
        this.m_iTaskRolesSelection[0] = 0;
        objectSize = this._systemObjects.size();
        Trace.trace(TRACE_MASKT, "AddRoleBean.fillRoles systemObjects " + this._systemObjects.size());
        this.m_idObjectRoles = new ItemDescriptor[objectSize];
        this.m_cdObjectRolesStructure = new ColumnDescriptor[0];
        this.m_iObjectRolesSelection = new int[1];
        this.m_iObjectRolesSelection[0] = 0;
        i = 0;
        while (i < taskSize) {
            newRow = new ItemDescriptor[1];
            itemTree = (RoleTree)this._systemTasks.get(i);
            itemName = itemTree.getName().toString();
            newRow[0] = new ItemDescriptor("i" + String.valueOf(i), itemName);
            this.setTaskRolesRowAt(i, newRow);
            ++i;
        }
        i = 0;
        while (i < objectSize) {
            newRow = new ItemDescriptor[1];
            itemTree = (RoleTree)this._systemObjects.get(i);
            itemName = itemTree.getName().toString();
            newRow[0] = new ItemDescriptor("xi" + String.valueOf(i), itemName);
            this.setObjectRolesRowAt(i, newRow);
            ++i;
        }
        this._utm.refreshElement("ObjectRoles");
        this._utm.refreshElement("TaskRoles");
    }

    public void issueAddError() {
        try {
            BaseMessageTitle title = new BaseMessageTitle("ADM9006");
            BaseMessageText msg = new BaseMessageText("ADM0008");
            CommonMsgApp.showMessageBox(this.getUserTaskManager(), title, msg);
        }
        catch (HException e) {}
    }

    public void issueDeleteObjectError() {
        BaseMessageTitle title = new BaseMessageTitle("ADM9011");
        MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("ADM0021")};
        LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
        try {
            CommonMsgApp.showMessageBox(this.userTaskManager, title, bmt, "ADM0021", MsgType.INFORMATION_MESSAGE, options);
        }
        catch (Exception exc) {
            HException ex = new HException(exc);
            new FrameworkLog(classLogInfo, 1025, ex).log();
        }
    }

    public boolean isRemoveable(int selected, int path) {
        Trace.trace(TRACE_MASKT, "AddRoleBean.isRemoveable selected " + selected);
        Trace.trace(TRACE_MASKT, "AddRoleBean.isRemoveable path " + path);
        boolean removeable = true;
        RoleTree badRole = path == 0 ? (RoleTree)this._systemObjects.get(selected) : (RoleTree)this._systemTasks.get(selected);
        Trace.trace(TRACE_MASKT, "-> isRemoveable() " + badRole.getName());
        Trace.trace(TRACE_MASKT, "-> is this item editable? " + badRole.isEditable());
        if (badRole.isEditable()) {
            try {
                LocalizableText ans = CommonMsgApp.showMessageBox(this.userTaskManager, (LocalizableText)new BaseMessageTitle("ADM9004"), new BaseMessageText("ADM0006"), null, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON});
                if (ans.equals(CommonMsgInterface.NO_BUTTON)) {
                    removeable = false;
                }
            }
            catch (Exception e) {}
        } else {
            this.issueDeleteObjectError();
            removeable = false;
        }
        Trace.trace(TRACE_MASKT, "<- isRemoveable(selected) ");
        return removeable;
    }
}

